//
//	NOTE 
//	this is bare minimum PCE example. 
//	

#include "c2/tg16/huc6280.s"
#include "c2/tg16/vdc.s"

#define DATA_START $4000

macro FILL @n
{
	for(int r=0;r<n;r++)
	{
		BYTE 0
	}
}

//	we treat the font as if it's on a fixed page 
//	page 0 = $0000
//	page 1 = $1000 

macro ASCII.w @page,@palette,@data...
{
    for(size_t r=0;r<data.size();r++)
    {
        push8(data[r]-32);
        push8(page|(palette<<4));
    }
}

	//	zeropage/ram 
	@ = RAM_LOCATION

vsr:	byte 0

#define MAX_Sprites 64

//	avoid stack
	@ = RAM_LOCATION + $200
Sprites:
.id:            fill MAX_Sprites
.attr:          fill MAX_Sprites
.xmove:         fill MAX_Sprites
.ymove:         fill MAX_Sprites
.xpos: 	        fill MAX_Sprites
.ypos:  	      fill MAX_Sprites

	@ = $e000
//	pretty much PCE boilerplate
onReset:

	sei 
  csh //	Change Speed High
  cld // Clear Decimal Flag
	stz TIMER_reload
	ldx #$ff
	txs
  lda #$ff 				// hardware/IO 	$0000-$1fff
  tam #%00000001 
  lda #$f8 				//	ram/ZP 		$2000-$3fff
  tam #%00000010 
  lda #1					//	prgrom1		$4000-$5fff 
  tam #%00000100
  lda #2					//	prgrom2		$6000-$7fff
  tam #%00001000 
  lda #3					//	prgrom3		$8000-$9fff
  tam #%00010000 
  lda #4					//	prgrom4		$a000-$bfff 
  tam #%00100000 
  lda #5					//	prgrom4		$c000-$dfff 
  tam #%01000000 
  lda #0					//	prgrom0		$e000-$ffff 
  tam #%10000000 

	stz    	RAM_LOCATION                	// clear all the RAM
	tii    	RAM_LOCATION,RAM_LOCATION+1,$1FFF

	lda #$7
	sta IRQ_disable
	stz IRQ_status

  _vdc_reg #VDC_CR,#0
  _vdc_reg #VDC_RCR,#0
  _vdc_reg #VDC_BXR,#0
  _vdc_reg #VDC_BYR,#$0000
  _vdc_reg #VDC_MWR,#MAP_32x32

  _vdc_reg #VDC_VSR,#$0d07
  _vdc_reg #VDC_VDR,#224
  _vdc_reg #VDC_VCR,#$0003
  _vdc_reg #VDC_DMA_CR,#%00010001  
	_vdc_reg #VDC_SAT_SRC,#$7f00

	//	clear vram
  st0 #VDC_MAWR // VDC: Set VDC Address To Memory Address Write Register (VRAM Write Address) (MAWR)
  st1 #$00      
  st2 #$08      
  st0 #VDC_VWR // VDC: Set VDC Address To VRAM Data Write Register (VWR)
  tia RAM_LOCATION,VDC_DATA_L,$8000 
	//	we do this twice, to just keep going into the VRAM
  tia RAM_LOCATION,VDC_DATA_L,$8000 

	_vdc_upload BGCHR,$1000,3040
	_vce_upload Colors,$000,16
	_vce_upload Colors,$100,16	//	and sprites 
	_vdc_upload Screen,$0000,Screen.End-Screen
	_vdc_upload SPRCHR,$1800,128

	jsr SpritePositionSetup

	_vdc_256_wide
  _vdc_reg #VDC_CR,#(VDP_IRQ_ENABLE | VDP_BG_ENABLE | VDP_SPR_ENABLE )
	//	PCE
	lda #%00000001 
	sta IRQ_disable
	stz IRQ_status
	cli

	jmp @

Directions:
	BYTE $ff,1

SpritePositionSetup:
{
//  set up default move 
//  we're just grabbing ROM data and mapping it to -1 or 1 
	ldx #$00 
.resetSpr:
	lda $e001,x 
	and #1 
	tay 
	lda Directions,y 
	sta Sprites.xmove,x
	lda $e023,x 
	sta Sprites.xpos,x 
	lda $e004,x 
	sta Sprites.ypos,x 

	lda $e01f,x 
	and #1 
	tay 
	lda Directions,y 
	sta Sprites.ymove,x 

	//  make the sprite ID the ball 
	lda #$c0
	sta Sprites.id,x
	inx 
	cpx #MAX_Sprites
	bne .resetSpr
	rts
}
onTimer:
{
	pha
	sta IRQ_status	//ACK TIMER
	stz TIMER_control	//Turn off timer
	pla
	rti
}

#define sprflag SPR_Y16 | SPR_PRIORITY

PCE_bounce_sprites:
{
	st0 #$00
	st1 #$00
	st2 #$7f
	st0 #2

	ldx #$00 
	ldy #$00 
loopSpr:	
//	we're only dealing with 8 bit coords
	//	Y
	lda Sprites.ypos,x 
	clc 
	adc Sprites.ymove,x 
	sta VDC_DATA_L
	sta Sprites.ypos,x 
	bne .nbounceY
	lda Sprites.ymove,x 
	eor #$ff
	adc #0 
	sta Sprites.ymove,x
.nbounceY:
	lda #$00 
	sta VDC_DATA_H
	//	X
	lda Sprites.xpos,x 
	clc 
	adc Sprites.xmove,x 
	sta VDC_DATA_L
	sta Sprites.xpos,x 

	bne .nbounceX
	lda Sprites.xmove,x 
	eor #$ff
	adc #0 
	sta Sprites.xmove,x
.nbounceX:



	lda #$00
	sta VDC_DATA_H

	//	
	lda Sprites.id,x
	sta VDC_DATA_L
	lda #$0
	sta VDC_DATA_H
	txa
	ora #sprflag&255
	sta VDC_DATA_L
	lda #sprflag>>8
	sta VDC_DATA_H
	inx 
	cpx #MAX_Sprites
	bne loopSpr
	st0 #$13 
	st1 #$00
	st2 #$7f
	rts
}


//	vblank
onIRQ:
{
	pha
	phx
	phy
	lda VDC_REG_SELECT
	sta vsr
	and #$2 
	beq vsynccheck
	stz $106
	stz $106
vsynccheck:
	lda vsr
	and #$20
	beq exit
	jsr PCE_bounce_sprites

//	jsr _vdc_sprites
//	jsr _vdc_upload_SATB
//	inc	framesync 
exit:	
	stz VDC_REG_SELECT
	ply
	plx
	pla
	rti
}	

onNMI:
onIRQ2:
	rti

Screen:
	ASCII.w 1,$0,"   Simple ROM built with C2     "
	ASCII.w 1,$1,"   (C)2023 John Hammarberg      "
	ASCII.w 1,$2,"                                "
	ASCII.w 1,$3,"         65C02 Support          "
	ASCII.w 1,$4,"        HuC6280 Support         "
	ASCII.w 1,$5,"     PCE support added by       "
	ASCII.w 1,$6,"        MonstersGoBoom          "
	ASCII.w 1,$7,"                                "
	ASCII.w 1,$8,"hello world ! what is up !      "
	ASCII.w 1,$9,"hello world ! what is up !      "
	ASCII.w 1,$a,"hello world ! what is up !      "
	ASCII.w 1,$b,"hello world ! what is up !      "
	ASCII.w 1,$c,"hello world ! what is up !      "
	ASCII.w 1,$d,"hello world ! what is up !      "
	ASCII.w 1,$e,"hello world ! what is up !      "
	ASCII.w 1,$f,"hello world ! what is up !      "
	ASCII.w 1,$0,"hello world ! what is up !      "
	ASCII.w 1,$1,"hello world ! what is up !      "
	ASCII.w 1,$2,"hello world ! what is up !      "
	ASCII.w 1,$3,"hello world ! what is up !      "
	ASCII.w 1,$4,"hello world ! what is up !      "
	ASCII.w 1,$5,"hello world ! what is up !      "
	ASCII.w 1,$6,"hello world ! what is up !      "
	ASCII.w 1,$7,"hello world ! what is up !      "
	ASCII.w 1,$8,"hello world ! what is up !      "
	ASCII.w 1,$9,"hello world ! what is up !      "
	ASCII.w 1,$a,"hello world ! what is up !      "
	ASCII.w 1,$b,"hello world ! what is up !      "
	ASCII.w 1,$c,"hello world ! what is up !      "
	ASCII.w 1,$d,"hello world ! what is up !      "
.End:


Colors:
	RGB 016,016,016
	RGB 036,000,072
	RGB 072,109,182
	RGB 072,182,255

	RGB 000,072,036
	RGB 000,145,036
	RGB 072,072,109
	RGB 109,145,145

	RGB 036,000,000
	RGB 145,000,036
	RGB 182,072,000
	RGB 255,109,109

	RGB 218,145,000
	RGB 255,218,072
	RGB 255,255,218
	RGB 255,255,255

//	NO CODE or DATA after this, besides IRQ vectors and CHRROM 
//  IRQ vectors

	@ = $fff6
	word onIRQ2 
	word onIRQ 
	word onTimer 
	word onNMI
	@ = $fffe
	word onReset

	@ = $10000,DATA_START
BGCHR:
//	we're lazy here and the 1bit font is converted already into 4bpp 
//	you COULD/SHOULD use a 1 bit font and fix during upload 
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $10, $00, $10, $00, $10, $00, $00, $00, $00, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $24, $00, $24, $00, $24, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $24, $00, $24, $00, $7E, $00, $24, $00, $7E, $00, $24, $00, $24, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $3C, $00, $50, $00, $38, $00, $14, $00, $78, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $62, $00, $64, $00, $08, $00, $10, $00, $26, $00, $46, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $30, $00, $48, $00, $48, $00, $30, $00, $4A, $00, $44, $00, $3A, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $08, $00, $10, $00, $20, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $08, $00, $10, $00, $20, $00, $20, $00, $20, $00, $10, $00, $08, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $20, $00, $10, $00, $08, $00, $08, $00, $08, $00, $10, $00, $20, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $54, $00, $38, $00, $10, $00, $38, $00, $54, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $10, $00, $10, $00, $7C, $00, $10, $00, $10, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $08, $00, $08, $00, $10, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $7C, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $02, $00, $04, $00, $08, $00, $10, $00, $20, $00, $40, $00, $80, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $44, $00, $4C, $00, $54, $00, $64, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $30, $00, $50, $00, $10, $00, $10, $00, $10, $00, $7C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $44, $00, $04, $00, $08, $00, $30, $00, $40, $00, $7C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $44, $00, $04, $00, $18, $00, $04, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $08, $00, $18, $00, $28, $00, $48, $00, $7C, $00, $08, $00, $08, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $40, $00, $78, $00, $04, $00, $04, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $1C, $00, $20, $00, $40, $00, $78, $00, $44, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $04, $00, $08, $00, $10, $00, $20, $00, $20, $00, $20, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $44, $00, $44, $00, $38, $00, $44, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $44, $00, $44, $00, $3C, $00, $04, $00, $08, $00, $70, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $10, $00, $00, $00, $00, $00, $10, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $10, $00, $00, $00, $00, $00, $10, $00, $10, $00, $20, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $08, $00, $10, $00, $20, $00, $40, $00, $20, $00, $10, $00, $08, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $7C, $00, $00, $00, $7C, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $20, $00, $10, $00, $08, $00, $04, $00, $08, $00, $10, $00, $20, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $04, $00, $08, $00, $08, $00, $00, $00, $08, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $4A, $00, $56, $00, $4C, $00, $40, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $18, $00, $24, $00, $42, $00, $7E, $00, $42, $00, $42, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $42, $00, $42, $00, $7C, $00, $42, $00, $42, $00, $7C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $40, $00, $40, $00, $40, $00, $42, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $78, $00, $44, $00, $42, $00, $42, $00, $42, $00, $44, $00, $78, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7E, $00, $40, $00, $40, $00, $78, $00, $40, $00, $40, $00, $7E, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7E, $00, $40, $00, $40, $00, $78, $00, $40, $00, $40, $00, $40, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $40, $00, $4E, $00, $42, $00, $42, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $42, $00, $42, $00, $7E, $00, $42, $00, $42, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $04, $00, $04, $00, $04, $00, $04, $00, $04, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $44, $00, $48, $00, $70, $00, $48, $00, $44, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $40, $00, $40, $00, $40, $00, $40, $00, $40, $00, $40, $00, $7E, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $66, $00, $5A, $00, $42, $00, $42, $00, $42, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $62, $00, $52, $00, $4A, $00, $46, $00, $42, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $42, $00, $42, $00, $42, $00, $42, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $42, $00, $42, $00, $7C, $00, $40, $00, $40, $00, $40, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $42, $00, $42, $00, $4A, $00, $44, $00, $3A, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $42, $00, $42, $00, $7C, $00, $48, $00, $44, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $3C, $00, $42, $00, $40, $00, $3C, $00, $02, $00, $42, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $42, $00, $42, $00, $42, $00, $42, $00, $42, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $42, $00, $42, $00, $42, $00, $42, $00, $24, $00, $18, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $42, $00, $42, $00, $42, $00, $5A, $00, $66, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $42, $00, $42, $00, $24, $00, $18, $00, $24, $00, $42, $00, $42, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $44, $00, $44, $00, $44, $00, $38, $00, $10, $00, $10, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $7C, $00, $04, $00, $08, $00, $10, $00, $20, $00, $40, $00, $7C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $20, $00, $20, $00, $20, $00, $20, $00, $20, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $80, $00, $40, $00, $20, $00, $10, $00, $08, $00, $04, $00, $02, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $38, $00, $08, $00, $08, $00, $08, $00, $08, $00, $08, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $28, $00, $44, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $7C, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $20, $00, $10, $00, $08, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $38, $00, $04, $00, $3C, $00, $44, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $40, $00, $40, $00, $78, $00, $44, $00, $44, $00, $44, $00, $78, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $38, $00, $44, $00, $40, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $04, $00, $04, $00, $3C, $00, $44, $00, $44, $00, $44, $00, $3C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $38, $00, $44, $00, $7C, $00, $40, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $0C, $00, $12, $00, $10, $00, $7C, $00, $10, $00, $10, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $3C, $00, $44, $00, $44, $00, $3C, $00, $04, $00, $38, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $40, $00, $40, $00, $78, $00, $44, $00, $44, $00, $44, $00, $44, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $00, $00, $30, $00, $10, $00, $10, $00, $10, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $04, $00, $00, $00, $0C, $00, $04, $00, $04, $00, $04, $00, $24, $00, $18, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $40, $00, $40, $00, $44, $00, $48, $00, $70, $00, $48, $00, $44, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $30, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $68, $00, $54, $00, $54, $00, $54, $00, $54, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $78, $00, $44, $00, $44, $00, $44, $00, $44, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $38, $00, $44, $00, $44, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $78, $00, $44, $00, $44, $00, $78, $00, $40, $00, $40, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $3C, $00, $44, $00, $44, $00, $3C, $00, $04, $00, $04, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $5C, $00, $60, $00, $40, $00, $40, $00, $40, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $3C, $00, $40, $00, $38, $00, $04, $00, $78, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $20, $00, $20, $00, $78, $00, $20, $00, $20, $00, $24, $00, $18, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $44, $00, $44, $00, $44, $00, $44, $00, $38, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $44, $00, $44, $00, $44, $00, $28, $00, $10, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $44, $00, $54, $00, $54, $00, $54, $00, $28, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $44, $00, $28, $00, $10, $00, $28, $00, $44, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $44, $00, $44, $00, $44, $00, $3C, $00, $04, $00, $38, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $7C, $00, $08, $00, $10, $00, $20, $00, $7C, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $18, $00, $20, $00, $20, $00, $40, $00, $20, $00, $20, $00, $18, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00, $10, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $30, $00, $08, $00, $08, $00, $04, $00, $08, $00, $08, $00, $30, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $20, $00, $54, $00, $08, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	byte $FE, $00, $FE, $00, $FE, $00, $FE, $00, $FE, $00, $FE, $00, $FE, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	
SPRCHR:
	byte $00, $00, $00, $07, $C0, $1F, $C0, $1F, $E0, $3F, $E0, $3F, $E0, $3F, $C0, $1F
	byte $C0, $1F, $01, $87, $02, $40, $0E, $70, $F8, $3F, $F0, $1F, $E0, $07, $00, $00
	byte $F0, $0F, $FC, $3F, $FE, $7F, $FE, $7F, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF
	byte $FF, $FF, $FE, $7F, $FC, $3F, $F0, $0F, $00, $00, $00, $00, $00, $00, $00, $00
	byte $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
